/*
	A basic	extension of the java.applet.Applet	class
 */

import java.awt.*; 
import java.applet.*;
import sampling.*;
import misc.Debug;

public class SlidingWindowApplet extends Applet	{

	public static void main(String[] args) {
        Global.m_bIsApplet=false;
        applet = new SlidingWindowApplet();
		frame  = new AppletFrame("Sliding Window",applet,600,700);
		Debug.out("void	main");
	}

	public void	init() {
		super.init();
	    Debug.out("Applet: init");
	    Global.init(this);
		//{{INIT_CONTROLS
		setLayout(null);
		//addNotify();
		resize(600,700);
		//}}
		// Compose visual Objects
		senderPanel	= Global.sender.panel();
		senderPanel.reshape(10,10,280,250);
		add(senderPanel);
		receiverPanel =	Global.receiver.panel();
		receiverPanel.reshape(310,10,280,250);
		add(receiverPanel);
		channelPanel = Global.channel.panel();
		channelPanel.reshape(50,520,500,120);
		add(channelPanel);
		historyPanel = Global.historyPanel;
		historyPanel.reshape(20,270,560,240);
		add(historyPanel);
   		Global.historyPanel.clear();
		// Inits for Applets only
		Steuerung st = new Steuerung();

	}
	public void start() {
	    Debug.out("Applet:start");
	}
	public void stop() {
	    Debug.out("Applet:stop");
	}

	//{{DECLARE_CONTROLS
	//}}
	MenuPanel	senderPanel;
	MenuPanel	receiverPanel;
	MenuPanel	channelPanel;
	MenuPanel	historyPanel;
	static AppletFrame          frame;
	static SlidingWindowApplet  applet;
}

class AppletFrame extends Frame {
    public AppletFrame(String title,Applet applet,int iWidth,int iHeight) {
        // Create frame with title
        super(title);
        // Add applet to frame
        this.resize(iWidth,iHeight);
        applet.resize(iWidth,iHeight);
        this.add("Center",applet);
        // Start applet
        applet.init();
        applet.start();
        this.show();
    }
    public void paint(Graphics g) {
        //g.drawImage(Global.senderImage,0,0,this);
    }
    public boolean handleEvent(Event event) {
        if (event.id == Event.WINDOW_DESTROY)
            System.exit(0);
        return false;
    }
	//{{DECLARE_CONTROLS
	//}}
	//{{DECLARE_MENUS
	//}}
}